'<ADbasic Header, Headerversion 001.001>
' Process_Number                 = 1
' Initial_Processdelay           = 400
' Eventsource                    = Timer
' Control_long_Delays_for_Stop   = No
' Priority                       = High
' Version                        = 1
' ADbasic_Version                = 6.3.1
' Optimize                       = No
' Stacksize                      = 1000
' Info_Last_Save                 = TUD1003378  TUD1003378\LocalAdmin
'<Header End>
'electromigration_joeri.bas:
'
'-------------------Process outline-----------------------
'event loop:
'   1. set voltage output 1 to start voltage + count
'   2. read adc value of input 1 and convert to current
'   3. enter 'first_loop' (only at start of ramp) or 'main_loop'
'     - first_loop:
'       4. check if resistance > cut-off resistance (FPAR_1)
'       5. if yes: set output voltage to zero and exit program
'
'     - main loop:
'       4. check if one of the following conditions is met 
'         - cut-off voltage (PAR_2) is reached 
'         - change in resistance exceeds given value (FPAR_2)
'       5. if yes: - set output voltage and count to zero 
'                  - write final voltage and resistance in PAR_3 and FPAR_3 
'                  - Return to 1. (enter first loop)
'          if no:  - increase count by 1 
'                  - Return to 1. (enter main loop)
'
'------------------Global variables----------------------
'Inputs:
'   integers:
'PAR_1 = start voltage (native units)
'PAR_2 = cut-off voltage (native units)
'PAR_4 = delay time between DAC output and ADC read (in units of 0.1us)
'PAR_5 = steps back in voltage after end of ramp (native units) 
'        (note: PAR_5 = 0 --> step back to start voltage)
'PAR_6 = number of times adc reading is averaged
'   floats:
'FPAR_1 = target resistance (Ohm)
'FPAR_2 = maximum change in resistance relative to resistance at start voltage (>1.0)
'   arrays float:
'DATA_1 = conversion table to current (A)

'Outputs:
'   integers:
'PAR_3 = voltage last finished sweep (native units)
'   floats:
'FPAR_3 = resistance last finished sweep (Ohm)
'-------------------------------------------------------

DIM DATA_1[65536] as float 'lookup table for current in A
DIM v, adc_value, count, first_loop, count_back, i, reps, vmax as integer
DIM first_r, r as float

INIT:
  
  count = 0
  first_loop = 1
  adc_value = 0
  reps = 10
  vmax = 6000
  
  SET_MUX(0010000000b)    'ADC 1, gain 4
  sleep(100000)
  DAC(1, PAR_1)           'set voltage on output 1
  sleep(100000)
  
EVENT:
  
  v = PAR_1 + count 
  
  DAC(1, v)               'set voltage on output 1
  START_CONV(1)           'start analog to digital conversion
  WAIT_EOC(1)             'wait for conversion to be finished
  adc_value = READADC(1)  'read adc value of input 1
  first_r = (v-32768)/(DATA_1[adc_value]*3276.8)
  
  IF (first_r > FPAR_1) THEN
    END
  ENDIF
  
  FOR i = 1 TO reps
    START_CONV(1)           'start analog to digital conversion
    WAIT_EOC(1)             'wait for conversion to be finished
    adc_value = READADC(1)  'read adc value of input 1
    r = (v-32768)/(DATA_1[adc_value]*3276.8)
    IF (r/first_r > FPAR_2) THEN
      count = -1
      PAR_3 = v
      FPAR_3 = r
      i = reps      
    ENDIF    
  NEXT i
  
  IF (v+1 > vmax) THEN
    count = 0
  ELSE
    count = count + 1
  ENDIF
  
  
FINISH:
  DAC(1,32768)
  PAR_3 = v
  FPAR_3 = r
